<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\TwiML\Messaging;

use Twilio\TwiML\TwiML;

class Message extends TwiML {
    /**
     * Message constructor.
     * 
     * @param string $body Message Body
     * @param array $attributes Optional attributes
     */
    public function __construct($body, $attributes = array()) {
        parent::__construct('Message', $body, $attributes);
    }

    /**
     * Add Body child.
     * 
     * @param string $message Message Body
     * @return TwiML Child element.
     */
    public function body($message) {
        return $this->nest(new Messaging\Body($message));
    }

    /**
     * Add Media child.
     * 
     * @param url $url Media URL
     * @return TwiML Child element.
     */
    public function media($url) {
        return $this->nest(new Messaging\Media($url));
    }

    /**
     * Add To attribute.
     * 
     * @param phoneNumber $to Phone Number to send Message to
     * @return TwiML $this.
     */
    public function setTo($to) {
        return $this->setAttribute('to', $to);
    }

    /**
     * Add From attribute.
     * 
     * @param phoneNumber $from Phone Number to send Message from
     * @return TwiML $this.
     */
    public function setFrom($from) {
        return $this->setAttribute('from', $from);
    }

    /**
     * Add Action attribute.
     * 
     * @param url $action Action URL
     * @return TwiML $this.
     */
    public function setAction($action) {
        return $this->setAttribute('action', $action);
    }

    /**
     * Add Method attribute.
     * 
     * @param httpMethod $method Action URL Method
     * @return TwiML $this.
     */
    public function setMethod($method) {
        return $this->setAttribute('method', $method);
    }

    /**
     * Add StatusCallback attribute.
     * 
     * @param url $statusCallback Status callback URL. Deprecated in favor of
     *                            action.
     * @return TwiML $this.
     */
    public function setStatusCallback($statusCallback) {
        return $this->setAttribute('statusCallback', $statusCallback);
    }
}